﻿<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Zadania" %>
<%@ import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<script runat="server">

    // Poniżej zdefiniowana zostala klasa parametrów
    public class Parametry : Soneta.Business.ContextBase
    {
        bool bez;
       
        public Parametry(Context cx)
            : base(cx)
        {
           bez = false; }


        [Caption("Drukuj kont. bez osób")]

        public bool Bez
        {
            get { return bez; }
            set { bez = value; }
        }
       

    }
    // inicjacja klasy parametrów
    Parametry param = null;
    [Context]
    [Caption("Wydruk osób kontaktowych dla Kontrahentów")]
    public Parametry Param
    {
        get { return param; }
        set { param = value; }
    } 

    protected void dc_ContextLoad(object sender, EventArgs e)    
    {
        Soneta.Business.View v = (dc[typeof(Soneta.Business.View)]) as Soneta.Business.View;
       ArrayList Lk = new ArrayList();
       ArrayList Lk2 = new ArrayList();
        
       foreach (Kontrahent kont in v)
       {
           if (kont.OsobyKontaktowe != null && kont.OsobyKontaktowe.Count > 0)
           {
               foreach(Soneta.CRM.Osoba_Kontrahent.OsobaKontrahent ok in kont.OsobyKontaktowe)  
                    Lk.Add(ok);
               
           }
           else
               Lk2.Add(kont);
       }
       
        DataLabel1.EditValue="Kontrahenci nie posiadający osób kontaktowych";

        if (!Param.Bez)
        {
            DataLabel1.Visible = false; Grid1.Visible = false;
        }

       Grid1.DataSource = Lk2;
       Grid.DataSource = Lk;
            
    }
    
    public void MSG( string s)
    {
    
    }
    protected void Grid_BeforeRow(object sender, RowEventArgs args)
    {
       
       if (!((Soneta.CRM.Osoba_Kontrahent.OsobaKontrahent)args.Row).Nieaktualny)
           Aktywny.EditValue = "<table border='1' bgcolor='Green'><TR><TD> </TD></TR></table>";
       if (((Soneta.CRM.Osoba_Kontrahent.OsobaKontrahent)args.Row).Glowny)
           Glowny.EditValue = "<table border='1' bgcolor='Green'><TR><TD> </TD></TR></table>";
           

    }


</script>
<HTML>
	<HEAD>
		<TITLE>Lista osób - złożona</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Lista osób kontaktowych - złożona"></eb:ReportHeader>
 
            <ea:Grid id="Grid" runat="server" 
                RowTypeName="Soneta.CRM.Osoba_Kontrahent.OsobaKontrahent" 
                onbeforerow="Grid_BeforeRow" RowsInRow="2" Sort="Kontrahent,Glowny DESC,Nieaktualny" GroupData0="Kontrahent" GroupData1="Kontrahent.EMAIL" GroupLine="Kontrahent: {0}  {1}"  >
				<Columns>
						
					<ea:GridColumn Width="3"  DataMember="#" Caption="LP." RowSpan="2" Align="Center"></ea:GridColumn>
                    <ea:GridColumn Width="3" runat="server" ID="Glowny" DataMember="" Caption="Gł." RowSpan="2" Align="Center"></ea:GridColumn>
                    <ea:GridColumn Width="3" runat="server" ID="Aktywny" DataMember="" Caption="Akt." RowSpan="2" Align="Center"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="OsobaKontaktowa.Nazwisko" EncodeHTML="false" Caption="Nazwisko" Width="18"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="OsobaKontaktowa.Imie" EncodeHTML="false" Caption="Imię" Width="18"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Stanowisko" RowSpan="2" EncodeHTML="true" Caption="Stanowisko" Width="18"></ea:GridColumn>
                    <ea:GridColumn ID="GridColumn4" runat="server" Align="Left" DataMember="OsobaKontaktowa.Adres.Telefon" EncodeHTML="true" Caption="Tel. stac." Width="14"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="OsobaKontaktowa.Kontakt.TelefonKomorkowy" EncodeHTML="true" Caption="Tel. kom." Width="14"></ea:GridColumn>
                    <ea:GridColumn ID="GridColumn2" runat="server" Align="Left" ColSpan="2" DataMember="OsobaKontaktowa.Kontakt.EMAIL" EncodeHTML="true" Caption="EMAIL" Width="25"></ea:GridColumn>
                    <ea:GridColumn ID="GridColumn12" runat="server" Align="Left" ColSpan="2" DataMember="OsobaKontaktowa.Uwagi" EncodeHTML="true" Caption="Uwagi" ></ea:GridColumn>
			
				</Columns>
			</ea:Grid>

     <br />


                     <TABLE cellPadding=3 cellSpacing=0 width=100% border=0>
	<TR>

		<TD ROWSPAN=1 width=100% vAlign=center align=left style='BORDER-RIGHT: #c0c0c0 1px solid; BORDER-TOP: #c0c0c0 1px solid; FONT-SIZE: 9pt; BORDER-LEFT: #c0c0c0 1px solid; BORDER-BOTTOM: #c0c0c0 1px solid; FONT-FAMILY: Tahoma'>
            <ea:DataLabel ID="DataLabel1" runat="server" > 
            </ea:DataLabel>
        </TD>
	</TR>

	<TR height=5><TD></TD></TR>
</TABLE>
 <ea:Grid id="Grid1" runat="server" 
                RowTypeName="Soneta.CRM.Kontrahent,Soneta.CRM" 
               >
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
                    <ea:GridColumn ID="GridColumn3" runat="server" Width="20" Align="Left" DataMember="Kod" EncodeHTML="true" Caption="Kod"></ea:GridColumn>
					<ea:GridColumn ID="GridColumn1" runat="server" Align="Left" DataMember="Nazwa" EncodeHTML="true" Caption="Nazwa"></ea:GridColumn>
				
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>
